import pytest
from src.tools import jobs
from src.api import IvrnetClient
from src.models import Environment


def test_environment_enum():
    assert Environment.PRODUCTION_CA == "production-ca"


def test_ivrnet_client_requires_auth():
    with pytest.raises(ValueError):
        IvrnetClient()


@pytest.mark.asyncio
async def test_create_email_job_webhook(monkeypatch):
    captured = {}

    class DummyClient:
        async def post(self, endpoint, payload):
            captured["endpoint"] = endpoint
            captured["payload"] = payload
            return {"ok": True}

    monkeypatch.setattr(jobs, "get_client", lambda *a, **k: DummyClient())

    await jobs.create_email_job(
        from_resource="from",
        to_resource="to",
        languagename="en",
        message={"en": "Hello"},
        subject={"en": "Subject"},
        start_time="2020-01-01T00:00:00Z",
        end_time="2020-01-01T01:00:00Z",
        webhook_url="https://example.com/hook",
    )

    assert captured["endpoint"] == "/email/"
    assert captured["payload"]["job"]["options"]["webhook"]["url"] == "https://example.com/hook"
