from typing import Optional, List, Dict, Any
from ..api import IvrnetClient
from ..models import Environment

def get_client(
    environment: Environment,
    api_key: Optional[str] = None,
    username: Optional[str] = None,
    password: Optional[str] = None,
    basic_auth: Optional[str] = None,
) -> IvrnetClient:
    return IvrnetClient(environment, api_key, username, password, basic_auth)

async def clear_email_bounce_list(
    resources: Optional[List[str]] = None,
    environment: Environment = Environment.PRODUCTION_CA,
    api_key: Optional[str] = None,
    username: Optional[str] = None,
    password: Optional[str] = None,
    basic_auth: Optional[str] = None,
) -> Dict[str, Any]:
    """Clear email bounce list."""
    client = get_client(environment, api_key, username, password, basic_auth)
    if resources:
        payload = {"to": [{"resource": r} for r in resources]}
        return await client.delete("/email/bouncelist/clearlist/", data=payload)
    else:
        return await client.delete("/email/bouncelist/cleardomain/")

async def upload_text_optin_list(
    resources: List[str],
    environment: Environment = Environment.PRODUCTION_CA,
    api_key: Optional[str] = None,
    username: Optional[str] = None,
    password: Optional[str] = None,
    basic_auth: Optional[str] = None,
) -> Dict[str, Any]:
    """Upload text opt-in list."""
    client = get_client(environment, api_key, username, password, basic_auth)
    payload = {"to": [{"resource": r} for r in resources]}
    return await client.post("/text/optin/", payload)
