from typing import Optional, List, Dict, Any
from ..api import IvrnetClient
from ..models import Environment

def get_client(
    environment: Environment,
    api_key: Optional[str] = None,
    username: Optional[str] = None,
    password: Optional[str] = None,
    basic_auth: Optional[str] = None,
) -> IvrnetClient:
    return IvrnetClient(environment, api_key, username, password, basic_auth)

async def get_job_errors(
    job_type: str, # voice, text, email
    days: int = 30,
    environment: Environment = Environment.PRODUCTION_CA,
    api_key: Optional[str] = None,
    username: Optional[str] = None,
    password: Optional[str] = None,
    basic_auth: Optional[str] = None,
) -> Dict[str, Any]:
    """Get job errors."""
    client = get_client(environment, api_key, username, password, basic_auth)
    params = {"days": days}
    return await client.get(f"/{job_type}/errors/", params=params)

async def get_webhook_errors(
    job_type: str, # voice, text, email
    days: int = 30,
    environment: Environment = Environment.PRODUCTION_CA,
    api_key: Optional[str] = None,
    username: Optional[str] = None,
    password: Optional[str] = None,
    basic_auth: Optional[str] = None,
) -> Dict[str, Any]:
    """Get webhook errors."""
    client = get_client(environment, api_key, username, password, basic_auth)
    params = {"days": days}
    return await client.get(f"/{job_type}/webhook/errors/", params=params)
