from mcp.server.fastmcp import FastMCP
from .tools.jobs import (
    create_voice_job,
    create_text_job,
    create_email_job,
    get_job,
    list_jobs,
    cancel_job,
    pause_resume_job,
    send_followup_message,
)
from .tools.voice_files import (
    create_voice_file_placeholder,
    list_voice_files,
    delete_voice_file,
)
from .tools.lists import (
    clear_email_bounce_list,
    upload_text_optin_list,
)
from .tools.errors import (
    get_job_errors,
    get_webhook_errors,
)

mcp = FastMCP("communication-mcp")

# Register tools
mcp.tool()(create_voice_job)
mcp.tool()(create_text_job)
mcp.tool()(create_email_job)
mcp.tool()(get_job)
mcp.tool()(list_jobs)
mcp.tool()(cancel_job)
mcp.tool()(pause_resume_job)
mcp.tool()(send_followup_message)

mcp.tool()(create_voice_file_placeholder)
mcp.tool()(list_voice_files)
mcp.tool()(delete_voice_file)

mcp.tool()(clear_email_bounce_list)
mcp.tool()(upload_text_optin_list)

mcp.tool()(get_job_errors)
mcp.tool()(get_webhook_errors)

# Expose the ASGI app for uvicorn
app = mcp.sse_app()

def main():
    mcp.run()

if __name__ == "__main__":
    main()
