# Communication MCP Middleware Server

This is an MCP server that acts as a middleware for the Ivrnet Message API.

## Features

- Voice, Text, and Email job management.
- Voice file management.
- List management (bounce list, opt-in list).
- Error reporting.
- Support for multiple environments (Production CA, Production US, Test).

## Usage

### Docker

```bash
docker-compose up --build
```

Once running, the MCP server is available at `http://localhost:8000/sse` (see `langflow_config.json`).

### Local Development

```bash
pip install -e .
python src/server.py
```

### Connect from Langflow

Import `langflow_config.json` into Langflow (or copy its values) so Langflow knows to talk to `http://localhost:8000/sse`.

### Testing

Install dev tooling and run pytest:

```bash
pip install -e .[dev]
pytest
```
